/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.core.config.AppliedConfigState;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.generation.BatchGenerator;
import com.seibel.distanthorizons.core.generation.WorldGenerationQueue;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.WorldGenModule;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.coreapi.DependencyInjection.WorldGeneratorInjector;
import org.apache.logging.log4j.Logger;

public class ServerLevelModule
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final IDhServerLevel parentServerLevel;
    public final AbstractSaveStructure saveStructure;
    public final GeneratedFullDataSourceProvider fullDataFileHandler;
    public final AppliedConfigState<Boolean> worldGeneratorEnabledConfig;
    public final WorldGenModule worldGenModule;

    public ServerLevelModule(IDhServerLevel parentServerLevel, AbstractSaveStructure saveStructure) {
        this.parentServerLevel = parentServerLevel;
        this.saveStructure = saveStructure;
        this.fullDataFileHandler = new GeneratedFullDataSourceProvider(parentServerLevel, saveStructure);
        this.worldGeneratorEnabledConfig = new AppliedConfigState<Boolean>(Config.Client.Advanced.WorldGenerator.enableDistantGeneration);
        this.worldGenModule = new WorldGenModule(this.parentServerLevel);
    }

    @Override
    public void close() {
        this.worldGenModule.close();
        this.fullDataFileHandler.close();
    }

    public static class WorldGenState
    extends WorldGenModule.AbstractWorldGenState {
        WorldGenState(IDhServerLevel level) {
            IDhApiWorldGenerator worldGenerator = WorldGeneratorInjector.INSTANCE.get(level.getLevelWrapper());
            if (worldGenerator == null) {
                worldGenerator = new BatchGenerator(level);
                WorldGeneratorInjector.INSTANCE.bind(level.getLevelWrapper(), worldGenerator);
            }
            this.worldGenerationQueue = new WorldGenerationQueue(worldGenerator);
        }
    }
}

